package org.msh.tb.bd.dashboard.detailedrep;

import org.jboss.seam.Component;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.contexts.Contexts;
import org.msh.tb.bd.dashboard.DashboardIndicatorUtils;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.TbCase;
import org.msh.tb.indicators.core.IndicatorFilters;
import org.msh.tb.login.UserSession;
import org.msh.utils.EntityQuery;
import org.msh.utils.date.DateUtils;
import org.msh.utils.date.Period;

import java.util.Arrays;
import java.util.List;

/**
 * Created by Mauricio on 17/05/2017.
 */
@Name("detailedIndicator07")
public class DetailedIndicator07 extends EntityQuery<TbCase> {

    private static String[] restrictions = {"c.registrationDate >= #{indicatorFilters.iniDate}",
            "c.registrationDate <= #{indicatorFilters.endDate}",
            "c.patient.gender = #{indicatorFilters.gender}",
            "c.age >= #{indicatorFilters.ageRange.iniAge}",
            "c.age <= #{indicatorFilters.ageRange.endAge}",
            "c.patient.workspace.id = #{defaultWorkspace.id}",
            "c.classification = #{indicatorFilters.classification}"};

    IndicatorFilters indicatorFilter;

    protected String staticHQLRestriction() {
        setOrder("datediff(c.treatmentPeriod.iniDate,c.registrationDate) desc");

        String hqlWhere = "where datediff(c.treatmentPeriod.iniDate, c.registrationDate) >= 0";

        // create administrative unit condition
        String auCondition = "";

        if (getIndicatorFilters() != null) {
            AdministrativeUnit auSelected = getIndicatorFilters().getTbunitselection().getAuselection().getSelectedUnit();

            if (auSelected != null) {
                auCondition = " and c.ownerUnit.adminUnit.code like '" + auSelected.getCode() + "%' ";
            }

        }
        return hqlWhere + auCondition;
    }

    @Override
    public List<String> getStringRestrictions() {
        return Arrays.asList(restrictions);
    }

    @Override
    protected String getCountEjbql() {
        return "select count(*) from TbCase c " + staticHQLRestriction();
    }


    @Override
    public String getEjbql() {
        return "select c from TbCase c " + staticHQLRestriction();
    }

    @Override
    public Integer getMaxResults() {
        return 50;
    }

    /**
     * Return the filters selected by the user
     * @return instance of the {@link IndicatorFilters IndicatorFilters} class
     */
    protected IndicatorFilters getIndicatorFilters() {
        if (indicatorFilter == null)
            indicatorFilter = (IndicatorFilters) Component.getInstance("indicatorFilters");
        return indicatorFilter;
    }

    @Override
    public void setOrder(String order) {
        super.setOrder(order);
    }
}
